//////////////////////////////////////////////////////////////////////////////
// DCTO9PKEYB.H - TO9+ keyboard definition
// Author   : Daniel Coulom - danielcoulom@gmail.com
// Web site : http://dcto9p.free.fr
// Created  : December 2007
//
// This file is part of DCTO9P v11.
// 
// DCTO9P v11 is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// DCTO9P v11 is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with DCTO9P v11.  If not, see <http://www.gnu.org/licenses/>.
//
//////////////////////////////////////////////////////////////////////////////
 
button to9pkey[TO9PKEY_MAX] = {
{"F7  F2",     48,  30,  36,  18,  0}, //0x00 
{" _ 6",      172,  60,  24,  24,  1}, //0x01
{"  Y",       184,  86,  24,  24,  2}, //0x02
{"  H",       192, 112,  24,  24,  3}, //0x03
{"[haut]",    420,  60,  24,  24,  4}, //0x04
{"[droite]",  432,  86,  24,  24,  5}, //0x05
{"RAZ",       372, 138,  32,  24,  6}, //0x06
{"  N",       204, 138,  24,  24,  7}, //0x07
{"F8  F3",     86,  30,  36,  18,  8}, //0x08
{" ( 5",      146,  60,  24,  24,  9}, //0x09
{"  T",       158,  86,  24,  24, 10}, //0x0a
{"  G",       166, 112,  24,  24, 11}, //0x0b
{"= +",       328,  60,  24,  24, 12}, //0x0c
{"[gauche]",  406,  86,  24,  24, 13}, //0x0d
{"INS",       406, 138,  24,  24, 14}, //0x0e
{"  B",       178, 138,  24,  24, 15}, //0x0f
{"F9  F4",    124,  30,  36,  18, 16}, //0x10
{" ' 4",      120,  60,  24,  24, 17}, //0x11
{"  R",       132,  86,  24,  24, 18}, //0x12
{"  F",       140, 112,  24,  24, 19}, //0x13
{"ACC",       380,  60,  24,  24, 20}, //0x14
{"  1   pad", 458, 112,  24,  24, 21}, //0x15
{"EFF",       432, 138,  24,  24, 22}, //0x16
{"  V",       152, 138,  24,  24, 23}, //0x17
{"F10 F5",    162,  30,  36,  18, 24}, //0x18
{" \" 3",      94,  60,  24,  24, 25}, //0x19
{"  E",       106,  86,  24,  24, 26}, //0x1a
{"  D",       114, 112,  24,  24, 27}, //0x1b
{"  7   pad", 458,  60,  24,  24, 28}, //0x1c
{"  4   pad", 458,  86,  24,  24, 29}, //0x1d
{"  0   pad", 458, 138,  24,  24, 30}, //0x1e
{"  C",       126, 138,  24,  24, 31}, //0x1f
{"F6  F1",     10,  30,  36,  18, 32}, //0x20
{"  2",       68,  60,  24,  24, 33}, //0x21
{"  Z",        80,  86,  24,  24, 34}, //0x22
{"  S",        88, 112,  24,  24, 35}, //0x23
{"  8   pad", 484,  60,  24,  24, 36}, //0x24
{"  2   pad", 484, 112,  24,  24, 37}, //0x25
{"  .   pad", 484, 138,  24,  24, 38}, //0x26
{"  X",       100, 138,  24,  24, 39}, //0x27
{" # @",       10,  60,  30,  24, 40}, //0x28
{" * 1",       42,  60,  24,  24, 41}, //0x29
{"  A",        54,  86,  24,  24, 42}, //0x2a
{"  Q",        62, 112,  24,  24, 43}, //0x2b
{" [ {",       36, 112,  24,  24, 44}, //0x2c
{"  5   pad", 484,  86,  24,  24, 45}, //0x2d
{"  6   pad", 510,  86,  24,  24, 46}, //0x2e
{"  W",        74, 138,  24,  24, 47}, //0x2f
{"  STOP",     10,  86,  42,  24, 48}, //0x30
{"  7",      198,  60,  24,  24, 49}, //0x31
{"  U",       210,  86,  24,  24, 50}, //0x32
{"  J",       218, 112,  24,  24, 51}, //0x33
{"ESPACE",    100, 164, 206,  24, 52}, //0x34
{"  9   pad", 510,  60,  24,  24, 53}, //0x35
{"ENT   pad", 510, 138,  24,  24, 54}, //0x36
{" , ?",      230, 138,  24,  24, 55}, //0x37
{"?????",     999,  30,  24,  24, 56}, //0x38
{" ! 8",      224,  60,  24,  24, 57}, //0x39
{"  I",       236,  86,  24,  24, 58}, //0x3a
{"  K",       244, 112,  24,  24, 59}, //0x3b
{"  $  &",    340,  86,  38,  24, 60}, //0x3c
{"[bas]",     420, 112,  24,  24, 61}, //0x3d
{"  ] }",     348, 112,  30,  24, 62}, //0x3e
{" ; .",      256, 138,  24,  24, 63}, //0x3f
{"?????",     999,  30,  24,  24, 64}, //0x40
{"  9",      250,  60,  24,  24, 65}, //0x41
{"  O",       262,  86,  24,  24, 66}, //0x42
{"  L",       270, 112,  24,  24, 67}, //0x43
{"  - \\",    354,  60,  24,  24, 68}, //0x44
{" %",       322, 112,  24,  24, 69}, //0x45
{"ENT",       380,  86,  24,  50, 70}, //0x46
{" : /",      282, 138,  24,  24, 71}, //0x47
{"?????",     999,  30,  24,  24, 72}, //0x48
{"  0",      276,  60,  24,  24, 73}, //0x49
{"  P",       288,  86,  24,  24, 74}, //0x4a
{"  M",       296, 112,  24,  24, 75}, //0x4b
{" ) ",      302,  60,  24,  24, 76}, //0x4c
{" ^ ",      314,  86,  24,  24, 77}, //0x4d
{"  3   pad", 510, 112,  24,  24, 78}, //0x4e
{"> <",       308, 138,  24,  24, 79}, //0x4f
{"LCK",        10, 138,  24,  24, 80}, //0x50
{"SHIFT",      36, 138,  36,  24, 81}, //0x51
{"SHIFT",     334, 138,  36,  24, 82}, //0x52
{"CNT",        10, 112,  24,  24, 83}  //0x53
};
 
button joykey[JOYKEY_MAX] = {
{"[0] haut",   135,  30, 0, 0, 84}, //0x00 
{"[0] bas",    135,  80, 0, 0, 87}, //0x01 
{"[0] gauche", 110,  55, 0, 0, 85}, //0x02 
{"[0] droite", 160,  55, 0, 0, 86}, //0x03 
{"[1] haut",   293,  30, 0, 0, 84}, //0x04 
{"[1] bas",    293,  80, 0, 0, 87}, //0x05 
{"[1] gauche", 268,  55, 0, 0, 85}, //0x06 
{"[1] droite", 318,  55, 0, 0, 86}, //0x07 
{"[0] action", 123, 112, 0, 0, 88}, //0x08 
{"[1] action", 281, 112, 0, 0, 88}  //0x09 
};
 
button keyboardbutton[KEYBOARDBUTTON_MAX] = {
{"[defaut]",  56, 249, 0, 0, 100}, //0x00 
{"[sauver]", 274, 249, 0, 0, 101}  //0x01 
};
 
button joystickbutton[JOYSTICKBUTTON_MAX] = {
{"[defaut]",  10, 209, 0, 0, 100}, //0x00 
{"[sauver]", 228, 209, 0, 0, 101}  //0x01 
};

#ifdef WIN32
//scancode hardware du PC Windows pour chaque touche TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pckeycode[TO9PKEY_MAX]=
{
0x3c, //0x00 F2 
0x07, //0x01 6
0x15, //0x02 Y
0x23, //0x03 H
0x48, //0x04 haut
0x4d, //0x05 droite
0x47, //0x06 RAZ
0x31, //0x07 N
0x3d, //0x08 F3
0x06, //0x09 5
0x14, //0x0a T
0x22, //0x0b G
0x0d, //0x0c +
0x4b, //0x0d gauche
0x52, //0x0e INS
0x30, //0x0f B
0x3e, //0x10 F4
0x05, //0x11 4
0x13, //0x12 R
0x21, //0x13 F
0x38, //0x14 ACC
0x8f, //0x15 1
0x53, //0x16 EFF
0x2f, //0x17 V
0x3f, //0x18 F5
0x04, //0x19 3
0x12, //0x1a E
0x20, //0x1b D
0x87, //0x1c 7 pad
0x8b, //0x1d 4 pad
0x92, //0x1e 0 pad
0x2e, //0x1f C
0x3b, //0x20 F1
0x03, //0x21 2
0x11, //0x22 Z
0x1f, //0x23 S
0x88, //0x24 8
0x90, //0x25 2
0x93, //0x26 .
0x2d, //0x27 X
0x29, //0x28 @
0x02, //0x29 1
0x10, //0x2a A
0x1e, //0x2b Q
0x56, //0x2c [
0x8c, //0x2d 5 pad
0x8d, //0x2e 6 pad
0x2c, //0x2f W
0x0f, //0x30 STOP
0x08, //0x31 7
0x16, //0x32 U
0x24, //0x33 J
0x39, //0x34 espace
0x89, //0x35 9 pad
0x5c, //0x36 Ent pad
0x32, //0x37 ,
0xff, //0x38 ?????????
0x09, //0x39 8
0x17, //0x3a I
0x25, //0x3b K
0x1b, //0x3c $
0x50, //0x3d bas
0x2b, //0x3e ]
0x33, //0x3f ;
0xff, //0x40 ?????????
0x0a, //0x41 9
0x18, //0x42 O
0x26, //0x43 L
0x0e, //0x44 -
0x28, //0x45 
0x1c, //0x46 Entree
0x34, //0x47 :
0xff, //0x48 ?????????
0x0b, //0x49 0
0x19, //0x4a P
0x27, //0x4b M
0x0c, //0x4c )
0x1a, //0x4d ^
0x91, //0x4e 3 pad
0x35, //0x4f > <
0x3a, //0x50 lock
0x2a, //0x51 left shift
0x36, //0x52 right shift
0x1d  //0x53 cnt
};

//scancode hardware du PC Windows pour chaque fonction des manettes TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pcjoycode[JOYKEY_MAX]=
{
 0x8c, //0 manette 0 HAUT 
 0x90, //1 manette 0 BAS
 0x8f, //2 manette 0 GAUCHE
 0x91, //3 manette 0 DROITE 
 0x75, //4 manette 1 HAUT 
 0x88, //5 manette 1 BAS
 0x87, //6 manette 1 GAUCHE
 0x89, //7 manette 1 DROITE
 0x5c, //8 manette 0 ACTION
 0x8e  //9 manette 1 ACTION
};

#else

//scancode hardware du PC Linux pour chaque touche TO9+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pckeycode[TO9PKEY_MAX]=
{
0x44, //0x00 F2 
0x0f, //0x01 6
0x1d, //0x02 Y
0x2b, //0x03 H
0x62, //0x04 haut
0x66, //0x05 droite
0x61, //0x06 RAZ
0x39, //0x07 N
0x45, //0x08 F3
0x0e, //0x09 5
0x1c, //0x0a T
0x2a, //0x0b G
0x15, //0x0c +
0x64, //0x0d gauche
0x6a, //0x0e INS
0x38, //0x0f B
0x46, //0x10 F4
0x0d, //0x11 4
0x1b, //0x12 R
0x29, //0x13 F
0x71, //0x14 ACC
0x97, //0x15 1
0x6b, //0x16 EFF
0x37, //0x17 V
0x47, //0x18 F5
0x0c, //0x19 3
0x1a, //0x1a E
0x28, //0x1b D
0x8f, //0x1c 7 pad
0x93, //0x1d 4 pad
0x9a, //0x1e 0 pad
0x36, //0x1f C
0x43, //0x20 F1
0x0b, //0x21 2
0x19, //0x22 Z
0x27, //0x23 S
0x90, //0x24 8
0x98, //0x25 2
0x9b, //0x26 .
0x35, //0x27 X
0x31, //0x28 @
0x0a, //0x29 1
0x18, //0x2a A
0x26, //0x2b Q
0x5e, //0x2c [
0x94, //0x2d 5 pad
0x95, //0x2e 6 pad
0x34, //0x2f W
0x17, //0x30 STOP
0x10, //0x31 7
0x1e, //0x32 U
0x2c, //0x33 J
0x41, //0x34 espace
0x91, //0x35 9 pad
0xac, //0x36 Ent pad
0x3a, //0x37 ,
0xff, //0x38 ?????????
0x11, //0x39 8
0x1f, //0x3a I
0x2d, //0x3b K
0x23, //0x3c $
0x68, //0x3d bas
0x33, //0x3e ]
0x3b, //0x3f ;
0xff, //0x40 ?????????
0x12, //0x41 9
0x20, //0x42 O
0x2e, //0x43 L
0x16, //0x44 -
0x30, //0x45 
0x24, //0x46 Entree
0x3c, //0x47 :
0xff, //0x48 ?????????
0x13, //0x49 0
0x21, //0x4a P
0x2f, //0x4b M
0x14, //0x4c )
0x22, //0x4d ^
0x99, //0x4e 3 pad
0x3d, //0x4f > <
0x42, //0x50 lock
0x32, //0x51 left shift
0x3e, //0x52 right shift
0x25  //0x53 cnt
};

//scancode hardware du PC Linux pour chaque fonction des manettes T09+
//(+ 0x40 pour les touches du pave numerique pour les distinguer des autres)
int pcjoycode[JOYKEY_MAX]=
{
 0x94, //0 manette 0 HAUT 
 0x98, //1 manette 0 BAS
 0x97, //2 manette 0 GAUCHE
 0x99, //3 manette 0 DROITE 
 0xb0, //4 manette 1 HAUT 
 0x90, //5 manette 1 BAS
 0x8f, //6 manette 1 GAUCHE
 0x91, //7 manette 1 DROITE
 0xac, //8 manette 0 ACTION
 0x96  //9 manette 1 ACTION
};

#endif
